"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    template_name: str,
    from_email_address: str,
    template_subject: str,
    template_content: str,
    success_redirection_url: str,
    failure_redirection_url: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom verification email template. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template.
        from_email_address(str): The email address that the custom verification email is sent from.
        template_subject(str): The subject line of the custom verification email.
        template_content(str): The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see Custom Verification Email Frequently Asked Questions in the Amazon SES Developer Guide.
        success_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
        failure_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.custom_verification_email.template.create(
                ctx,
                template_name=value,
                from_email_address=value,
                template_subject=value,
                template_content=value,
                success_redirection_url=value,
                failure_redirection_url=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.custom_verification_email.template.create template_name=value, from_email_address=value, template_subject=value, template_content=value, success_redirection_url=value, failure_redirection_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_custom_verification_email_template",
        op_kwargs={
            "TemplateName": template_name,
            "FromEmailAddress": from_email_address,
            "TemplateSubject": template_subject,
            "TemplateContent": template_content,
            "SuccessRedirectionURL": success_redirection_url,
            "FailureRedirectionURL": failure_redirection_url,
        },
    )


async def delete(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing custom verification email template. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.custom_verification_email.template.delete(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.custom_verification_email.template.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_custom_verification_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def get(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the custom email verification template for the template name you specify. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.custom_verification_email.template.get(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.custom_verification_email.template.get template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_custom_verification_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def list_all(hub, ctx, next_token: str = None, page_size: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the existing custom verification email templates for your account in the current AWS Region. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        next_token(str, optional): A token returned from a previous call to ListCustomVerificationEmailTemplates to indicate the position in the list of custom verification email templates. Defaults to None.
        page_size(int, optional): The number of results to show in a single call to ListCustomVerificationEmailTemplates. If the number of results is larger than the number you specified in this parameter, then the response includes a NextToken element, which you can use to obtain additional results. The value you specify has to be at least 1, and can be no more than 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.custom_verification_email.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.custom_verification_email.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_custom_verification_email_templates",
        op_kwargs={"NextToken": next_token, "PageSize": page_size},
    )


async def update(
    hub,
    ctx,
    template_name: str,
    from_email_address: str,
    template_subject: str,
    template_content: str,
    success_redirection_url: str,
    failure_redirection_url: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing custom verification email template. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to update.
        from_email_address(str): The email address that the custom verification email is sent from.
        template_subject(str): The subject line of the custom verification email.
        template_content(str): The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see Custom Verification Email Frequently Asked Questions in the Amazon SES Developer Guide.
        success_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
        failure_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.custom_verification_email.template.update(
                ctx,
                template_name=value,
                from_email_address=value,
                template_subject=value,
                template_content=value,
                success_redirection_url=value,
                failure_redirection_url=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.custom_verification_email.template.update template_name=value, from_email_address=value, template_subject=value, template_content=value, success_redirection_url=value, failure_redirection_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_custom_verification_email_template",
        op_kwargs={
            "TemplateName": template_name,
            "FromEmailAddress": from_email_address,
            "TemplateSubject": template_subject,
            "TemplateContent": template_content,
            "SuccessRedirectionURL": success_redirection_url,
            "FailureRedirectionURL": failure_redirection_url,
        },
    )
