"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "list"


async def create(
    hub,
    ctx,
    contact_list_name: str,
    topics: List = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a contact list.

    Args:
        contact_list_name(str): The name of the contact list.
        topics(List, optional): An interest group, theme, or label within a list. A contact list can have multiple topics. Defaults to None.
        description(str, optional): A description of what the contact list is about. Defaults to None.
        tags(List, optional): The tags associated with a contact list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.list_.create(ctx, contact_list_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.list.create contact_list_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_contact_list",
        op_kwargs={
            "ContactListName": contact_list_name,
            "Topics": topics,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, contact_list_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a contact list and all of the contacts on that list.

    Args:
        contact_list_name(str): The name of the contact list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.list_.delete(ctx, contact_list_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.list.delete contact_list_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_contact_list",
        op_kwargs={"ContactListName": contact_list_name},
    )


async def get(hub, ctx, contact_list_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns contact list metadata. It does not return any information about the contacts present in the list.

    Args:
        contact_list_name(str): The name of the contact list.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.list_.get(ctx, contact_list_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.list.get contact_list_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_contact_list",
        op_kwargs={"ContactListName": contact_list_name},
    )


async def list_all(hub, ctx, page_size: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the contact lists available.

    Args:
        page_size(int, optional): Maximum number of contact lists to return at once. Use this parameter to paginate results. If additional contact lists exist beyond the specified limit, the NextToken element is sent in the response. Use the NextToken value in subsequent requests to retrieve additional lists. Defaults to None.
        next_token(str, optional): A string token indicating that there might be additional contact lists available to be listed. Use the token provided in the Response to use in the subsequent call to ListContactLists with the same parameters to retrieve the next page of contact lists. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.list_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.list.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_contact_lists",
        op_kwargs={"PageSize": page_size, "NextToken": next_token},
    )


async def update(
    hub, ctx, contact_list_name: str, topics: List = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates contact list metadata. This operation does a complete replacement.

    Args:
        contact_list_name(str): The name of the contact list.
        topics(List, optional): An interest group, theme, or label within a list. A contact list can have multiple topics. Defaults to None.
        description(str, optional): A description of what the contact list is about. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.list_.update(ctx, contact_list_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.list.update contact_list_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_contact_list",
        op_kwargs={
            "ContactListName": contact_list_name,
            "Topics": topics,
            "Description": description,
        },
    )
