"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    contact_list_name: str,
    email_address: str,
    topic_preferences: List = None,
    unsubscribe_all: bool = None,
    attributes_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a contact, which is an end-user who is receiving the email, and adds them to a contact list.

    Args:
        contact_list_name(str): The name of the contact list to which the contact should be added.
        email_address(str): The contact's email address.
        topic_preferences(List, optional): The contact's preferences for being opted-in to or opted-out of topics. Defaults to None.
        unsubscribe_all(bool, optional): A boolean value status noting if the contact is unsubscribed from all contact list topics. Defaults to None.
        attributes_data(str, optional): The attribute data attached to a contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.init.create(
                ctx, contact_list_name=value, email_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.init.create contact_list_name=value, email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_contact",
        op_kwargs={
            "ContactListName": contact_list_name,
            "EmailAddress": email_address,
            "TopicPreferences": topic_preferences,
            "UnsubscribeAll": unsubscribe_all,
            "AttributesData": attributes_data,
        },
    )


async def delete(hub, ctx, contact_list_name: str, email_address: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a contact from a contact list.

    Args:
        contact_list_name(str): The name of the contact list from which the contact should be removed.
        email_address(str): The contact's email address.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.init.delete(
                ctx, contact_list_name=value, email_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.init.delete contact_list_name=value, email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_contact",
        op_kwargs={"ContactListName": contact_list_name, "EmailAddress": email_address},
    )


async def get(hub, ctx, contact_list_name: str, email_address: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a contact from a contact list.

    Args:
        contact_list_name(str): The name of the contact list to which the contact belongs.
        email_address(str): The contact's email addres.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.init.get(
                ctx, contact_list_name=value, email_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.init.get contact_list_name=value, email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_contact",
        op_kwargs={"ContactListName": contact_list_name, "EmailAddress": email_address},
    )


async def list_all(
    hub,
    ctx,
    contact_list_name: str,
    filter_: Dict = None,
    page_size: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the contacts present in a specific contact list.

    Args:
        contact_list_name(str): The name of the contact list.
        filter_(Dict, optional): A filter that can be applied to a list of contacts. Defaults to None.
        page_size(int, optional): The number of contacts that may be returned at once, which is dependent on if there are more or less contacts than the value of the PageSize. Use this parameter to paginate results. If additional contacts exist beyond the specified limit, the NextToken element is sent in the response. Use the NextToken value in subsequent requests to retrieve additional contacts. Defaults to None.
        next_token(str, optional): A string token indicating that there might be additional contacts available to be listed. Use the token provided in the Response to use in the subsequent call to ListContacts with the same parameters to retrieve the next page of contacts. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.init.list_all(ctx, contact_list_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.init.list_all contact_list_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="list_contacts",
        op_kwargs={
            "ContactListName": contact_list_name,
            "Filter": filter_,
            "PageSize": page_size,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    contact_list_name: str,
    email_address: str,
    topic_preferences: List = None,
    unsubscribe_all: bool = None,
    attributes_data: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a contact's preferences for a list. It is not necessary to specify all existing topic preferences in the TopicPreferences object, just the ones that need updating.

    Args:
        contact_list_name(str): The name of the contact list.
        email_address(str): The contact's email addres.
        topic_preferences(List, optional): The contact's preference for being opted-in to or opted-out of a topic. Defaults to None.
        unsubscribe_all(bool, optional): A boolean value status noting if the contact is unsubscribed from all contact list topics. Defaults to None.
        attributes_data(str, optional): The attribute data attached to a contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.contact.init.update(
                ctx, contact_list_name=value, email_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.contact.init.update contact_list_name=value, email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_contact",
        op_kwargs={
            "ContactListName": contact_list_name,
            "EmailAddress": email_address,
            "TopicPreferences": topic_preferences,
            "UnsubscribeAll": unsubscribe_all,
            "AttributesData": attributes_data,
        },
    )
