"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(
    hub, ctx, configuration_set_name: str, suppressed_reasons: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Specify the account suppression list preferences for a configuration set.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to change the suppression list preferences for.
        suppressed_reasons(List, optional): A list that contains the reasons that email addresses are automatically added to the suppression list for your account. This list can contain any or all of the following:    COMPLAINT – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.    BOUNCE – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.suppression_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.suppression_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_configuration_set_suppression_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "SuppressedReasons": suppressed_reasons,
        },
    )
