"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, configuration_set_name: str, sending_enabled: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to enable or disable email sending for.
        sending_enabled(bool, optional): If true, email sending is enabled for the configuration set. If false, email sending is disabled for the configuration set. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.sending_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.sending_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_configuration_set_sending_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "SendingEnabled": sending_enabled,
        },
    )
