"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    configuration_set_name: str,
    event_destination_name: str,
    event_destination: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an event destination. Events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage. A single configuration set can include more than one event destination.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to add an event destination to.
        event_destination_name(str): A name that identifies the event destination within the configuration set.
        event_destination(Dict): An object that defines the event destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.event_destination.create(
                ctx,
                configuration_set_name=value,
                event_destination_name=value,
                event_destination=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.event_destination.create configuration_set_name=value, event_destination_name=value, event_destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="create_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestinationName": event_destination_name,
            "EventDestination": event_destination,
        },
    )


async def delete(
    hub, ctx, configuration_set_name: str, event_destination_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Delete an event destination.  Events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.

    Args:
        configuration_set_name(str): The name of the configuration set that contains the event destination that you want to delete.
        event_destination_name(str): The name of the event destination that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.event_destination.delete(
                ctx, configuration_set_name=value, event_destination_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.event_destination.delete configuration_set_name=value, event_destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="delete_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestinationName": event_destination_name,
        },
    )


async def get_all(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a list of event destinations that are associated with a configuration set.  Events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.

    Args:
        configuration_set_name(str): The name of the configuration set that contains the event destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.event_destination.get_all(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.event_destination.get_all configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_configuration_set_event_destinations",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def update(
    hub,
    ctx,
    configuration_set_name: str,
    event_destination_name: str,
    event_destination: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Update the configuration of an event destination for a configuration set.  Events include message sends, deliveries, opens, clicks, bounces, and complaints. Event destinations are places that you can send information about these events to. For example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.

    Args:
        configuration_set_name(str): The name of the configuration set that contains the event destination that you want to modify.
        event_destination_name(str): The name of the event destination that you want to modify.
        event_destination(Dict): An object that defines the event destination.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.configuration_set_.event_destination.update(
                ctx,
                configuration_set_name=value,
                event_destination_name=value,
                event_destination=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.configuration_set_.event_destination.update configuration_set_name=value, event_destination_name=value, event_destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="update_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestinationName": event_destination_name,
            "EventDestination": event_destination,
        },
    )
