"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def send(
    hub,
    ctx,
    default_content: Dict,
    bulk_email_entries: List,
    from_email_address: str = None,
    from_email_address_identity_arn: str = None,
    reply_to_addresses: List = None,
    feedback_forwarding_email_address: str = None,
    feedback_forwarding_email_address_identity_arn: str = None,
    default_email_tags: List = None,
    configuration_set_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Composes an email message to multiple destinations.

    Args:
        from_email_address(str, optional): The email address that you want to use as the "From" address for the email. The address that you specify has to be verified. Defaults to None.
        from_email_address_identity_arn(str, optional): This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the FromEmailAddress parameter. For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use sender@example.com, then you would specify the FromEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the FromEmailAddress to be sender@example.com. For more information about sending authorization, see the Amazon SES Developer Guide. Defaults to None.
        reply_to_addresses(List, optional): The "Reply-to" email addresses for the message. When the recipient replies to the message, each Reply-to address receives the reply. Defaults to None.
        feedback_forwarding_email_address(str, optional): The address that you want bounce and complaint notifications to be sent to. Defaults to None.
        feedback_forwarding_email_address_identity_arn(str, optional): This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the email address specified in the FeedbackForwardingEmailAddress parameter. For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a policy to it that authorizes you to use feedback@example.com, then you would specify the FeedbackForwardingEmailAddressIdentityArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com, and the FeedbackForwardingEmailAddress to be feedback@example.com. For more information about sending authorization, see the Amazon SES Developer Guide. Defaults to None.
        default_email_tags(List, optional): A list of tags, in the form of name/value pairs, to apply to an email that you send using the SendEmail operation. Tags correspond to characteristics of the email that you define, so that you can publish email sending events. Defaults to None.
        default_content(Dict): An object that contains the body of the message. You can specify a template message.
        bulk_email_entries(List): The list of bulk email entry objects.
        configuration_set_name(str, optional): The name of the configuration set that you want to use when sending the email. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.bulk_email.send(
                ctx, default_content=value, bulk_email_entries=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.bulk_email.send default_content=value, bulk_email_entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="send_bulk_email",
        op_kwargs={
            "FromEmailAddress": from_email_address,
            "FromEmailAddressIdentityArn": from_email_address_identity_arn,
            "ReplyToAddresses": reply_to_addresses,
            "FeedbackForwardingEmailAddress": feedback_forwarding_email_address,
            "FeedbackForwardingEmailAddressIdentityArn": feedback_forwarding_email_address_identity_arn,
            "DefaultEmailTags": default_email_tags,
            "DefaultContent": default_content,
            "BulkEmailEntries": bulk_email_entries,
            "ConfigurationSetName": configuration_set_name,
        },
    )
