"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, blacklist_item_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a list of the blacklists that your dedicated IP addresses appear on.

    Args:
        blacklist_item_names(List): A list of IP addresses that you want to retrieve blacklist information about. You can only specify the dedicated IP addresses that you use to send email using Amazon SES or Amazon Pinpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.blacklist_report.get_all(ctx, blacklist_item_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.blacklist_report.get_all blacklist_item_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="get_blacklist_reports",
        op_kwargs={"BlacklistItemNames": blacklist_item_names},
    )
