"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(hub, ctx, suppressed_reasons: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Change the settings for the account-level suppression list.

    Args:
        suppressed_reasons(List, optional): A list that contains the reasons that email addresses will be automatically added to the suppression list for your account. This list can contain any or all of the following:    COMPLAINT – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a complaint.    BOUNCE – Amazon SES adds an email address to the suppression list for your account when a message sent to that address results in a hard bounce.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.account.suppression_attribute.put_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.account.suppression_attribute.put_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_account_suppression_attributes",
        op_kwargs={"SuppressedReasons": suppressed_reasons},
    )
