"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(hub, ctx, sending_enabled: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Enable or disable the ability of your account to send email.

    Args:
        sending_enabled(bool, optional): Enables or disables your account's ability to send email. Set to true to enable email sending, or set to false to disable email sending.  If AWS paused your account's ability to send email, you can't use this operation to resume your account's ability to send email. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.account.sending_attribute.put_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.account.sending_attribute.put_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_account_sending_attributes",
        op_kwargs={"SendingEnabled": sending_enabled},
    )
