"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Obtain information about the email-sending status and capabilities of your Amazon SES account in the current AWS Region.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.account.init.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.account.init.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="sesv2", operation="get_account", op_kwargs={}
    )
