"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(
    hub,
    ctx,
    mail_type: str,
    website_url: str,
    use_case_description: str,
    contact_language: str = None,
    additional_contact_email_addresses: List = None,
    production_access_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update your Amazon SES account details.

    Args:
        mail_type(str): The type of email your account will send.
        website_url(str): The URL of your website. This information helps us better understand the type of content that you plan to send.
        contact_language(str, optional): The language you would prefer to be contacted with. Defaults to None.
        use_case_description(str): A description of the types of email that you plan to send.
        additional_contact_email_addresses(List, optional): Additional email addresses that you would like to be notified regarding Amazon SES matters. Defaults to None.
        production_access_enabled(bool, optional): Indicates whether or not your account should have production access in the current AWS Region. If the value is false, then your account is in the sandbox. When your account is in the sandbox, you can only send email to verified identities. Additionally, the maximum number of emails you can send in a 24-hour period (your sending quota) is 200, and the maximum number of emails you can send per second (your maximum sending rate) is 1. If the value is true, then your account has production access. When your account has production access, you can send email to any address. The sending quota and maximum sending rate for your account vary based on your specific use case. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.sesv2.account.detail.put_multiple(
                ctx, mail_type=value, website_url=value, use_case_description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.sesv2.account.detail.put_multiple mail_type=value, website_url=value, use_case_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="sesv2",
        operation="put_account_details",
        op_kwargs={
            "MailType": mail_type,
            "WebsiteURL": website_url,
            "ContactLanguage": contact_language,
            "UseCaseDescription": use_case_description,
            "AdditionalContactEmailAddresses": additional_contact_email_addresses,
            "ProductionAccessEnabled": production_access_enabled,
        },
    )
