"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, email_address: str) -> None:
    r"""
    **Autogenerated function**

    Deprecated. Use the DeleteIdentity operation to delete email addresses and domains.

    Args:
        email_address(str): An email address to be removed from the list of verified addresses.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.verified_email_address.delete(ctx, email_address=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.verified_email_address.delete email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_verified_email_address",
        op_kwargs={"EmailAddress": email_address},
    )


async def list_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Deprecated. Use the ListIdentities operation to list the email addresses and domains associated with your account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.verified_email_address.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.verified_email_address.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ses", operation="list_verified_email_addresses", op_kwargs={}
    )
