"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, template: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template(Dict): The content of the email, composed of a subject line, an HTML part, and a text-only part.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.template.create(ctx, template=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.template.create template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_template",
        op_kwargs={"Template": template},
    )


async def delete(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an email template. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.template.delete(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.template.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_template",
        op_kwargs={"TemplateName": template_name},
    )


async def get(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the template object (which includes the Subject line, HTML part and text part) for the template you specify. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the template you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.template.get(ctx, template_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.template.get template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="get_template",
        op_kwargs={"TemplateName": template_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_items: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the email templates present in your Amazon SES account in the current AWS Region. You can execute this operation no more than once per second.

    Args:
        next_token(str, optional): A token returned from a previous call to ListTemplates to indicate the position in the list of email templates. Defaults to None.
        max_items(int, optional): The maximum number of templates to return. This value must be at least 1 and less than or equal to 10. If you do not specify a value, or if you specify a value less than 1 or greater than 10, the operation will return up to 10 results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="list_templates",
        op_kwargs={"NextToken": next_token, "MaxItems": max_items},
    )


async def update(hub, ctx, template: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates an email template. Email templates enable you to send personalized email to one or more destinations in a single API operation. For more information, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template(Dict): The content of the email, composed of a subject line, an HTML part, and a text-only part.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.template.update(ctx, template=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.template.update template=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_template",
        op_kwargs={"Template": template},
    )
