"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, rule_set_name: str, rule_name: str, after: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Sets the position of the specified receipt rule in the receipt rule set. For information about managing receipt rules, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str): The name of the receipt rule set that contains the receipt rule to reposition.
        rule_name(str): The name of the receipt rule to reposition.
        after(str, optional): The name of the receipt rule after which to place the specified receipt rule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.rule.position.set(
                ctx, rule_set_name=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.rule.position.set rule_set_name=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="set_receipt_rule_position",
        op_kwargs={"RuleSetName": rule_set_name, "RuleName": rule_name, "After": after},
    )
