"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, rule_set_name: str, rule: Dict, after: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a receipt rule. For information about setting up receipt rules, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str): The name of the rule set that the receipt rule will be added to.
        after(str, optional): The name of an existing rule after which the new rule will be placed. If this parameter is null, the new rule will be inserted at the beginning of the rule list. Defaults to None.
        rule(Dict): A data structure that contains the specified rule's name, actions, recipients, domains, enabled status, scan status, and TLS policy.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.rule.init.create(
                ctx, rule_set_name=value, rule=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.rule.init.create rule_set_name=value, rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_receipt_rule",
        op_kwargs={"RuleSetName": rule_set_name, "After": after, "Rule": rule},
    )


async def delete(hub, ctx, rule_set_name: str, rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified receipt rule. For information about managing receipt rules, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str): The name of the receipt rule set that contains the receipt rule to delete.
        rule_name(str): The name of the receipt rule to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.rule.init.delete(
                ctx, rule_set_name=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.rule.init.delete rule_set_name=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_receipt_rule",
        op_kwargs={"RuleSetName": rule_set_name, "RuleName": rule_name},
    )


async def describe(hub, ctx, rule_set_name: str, rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of the specified receipt rule. For information about setting up receipt rules, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str): The name of the receipt rule set that the receipt rule belongs to.
        rule_name(str): The name of the receipt rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.rule.init.describe(
                ctx, rule_set_name=value, rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.rule.init.describe rule_set_name=value, rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="describe_receipt_rule",
        op_kwargs={"RuleSetName": rule_set_name, "RuleName": rule_name},
    )


async def update(hub, ctx, rule_set_name: str, rule: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Updates a receipt rule. For information about managing receipt rules, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str): The name of the receipt rule set that the receipt rule belongs to.
        rule(Dict): A data structure that contains the updated receipt rule information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.rule.init.update(
                ctx, rule_set_name=value, rule=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.rule.init.update rule_set_name=value, rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_receipt_rule",
        op_kwargs={"RuleSetName": rule_set_name, "Rule": rule},
    )
