"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "filter"


async def create(hub, ctx, filter_: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new IP address filter. For information about setting up IP address filters, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        filter_(Dict): A data structure that describes the IP address filter to create, which consists of a name, an IP address range, and whether to allow or block mail from it.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.filter_.create(ctx, filter_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.filter.create filter_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_receipt_filter",
        op_kwargs={"Filter": filter_},
    )


async def delete(hub, ctx, filter_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified IP address filter. For information about managing IP address filters, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        filter_name(str): The name of the IP address filter to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.filter_.delete(ctx, filter_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.filter.delete filter_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_receipt_filter",
        op_kwargs={"FilterName": filter_name},
    )


async def list_all(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Lists the IP address filters associated with your AWS account in the current AWS Region. For information about managing IP address filters, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.receipt.filter_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.receipt.filter.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ses", operation="list_receipt_filters", op_kwargs={}
    )
