"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, identities: List) -> Dict:
    r"""
    **Autogenerated function**

    Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity. The verification status of an email address is "Pending" until the email address owner clicks the link within the verification email that Amazon SES sent to that address. If the email address owner clicks the link within 24 hours, the verification status of the email address changes to "Success". If the link is not clicked within 24 hours, the verification status changes to "Failed." In that case, if you still want to verify the email address, you must restart the verification process from the beginning. For domain identities, the domain's verification status is "Pending" as Amazon SES searches for the required TXT record in the DNS settings of the domain. When Amazon SES detects the record, the domain's verification status changes to "Success". If Amazon SES is unable to detect the record within 72 hours, the domain's verification status changes to "Failed." In that case, if you still want to verify the domain, you must restart the verification process from the beginning. This operation is throttled at one request per second and can only get verification attributes for up to 100 identities at a time.

    Args:
        identities(List): A list of identities.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.verification_attribute.get_all(
                ctx, identities=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.verification_attribute.get_all identities=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="get_identity_verification_attributes",
        op_kwargs={"Identities": identities},
    )
