"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    identity: str,
    mail_from_domain: str = None,
    behavior_on_mx_failure: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).  To send emails using the specified MAIL FROM domain, you must add an MX record to your MAIL FROM domain's DNS settings. If you want your emails to pass Sender Policy Framework (SPF) checks, you must also add or update an SPF record. For more information, see the Amazon SES Developer Guide.  You can execute this operation no more than once per second.

    Args:
        identity(str): The verified identity for which you want to enable or disable the specified custom MAIL FROM domain.
        mail_from_domain(str, optional): The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not be used in a "From" address if the MAIL FROM domain is the destination of email feedback forwarding (for more information, see the Amazon SES Developer Guide), and 3) not be used to receive emails. A value of null disables the custom MAIL FROM setting for the identity. Defaults to None.
        behavior_on_mx_failure(str, optional): The action that you want Amazon SES to take if it cannot successfully read the required MX record when you send an email. If you choose UseDefaultValue, Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM domain. If you choose RejectMessage, Amazon SES will return a MailFromDomainNotVerified error and not send the email. The action specified in BehaviorOnMXFailure is taken when the custom MAIL FROM domain setup is in the Pending, Failed, and TemporaryFailure states. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.mail_from_domain.init.set(ctx, identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.mail_from_domain.init.set identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="set_identity_mail_from_domain",
        op_kwargs={
            "Identity": identity,
            "MailFromDomain": mail_from_domain,
            "BehaviorOnMXFailure": behavior_on_mx_failure,
        },
    )
