"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, identity: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified identity (an email address or a domain) from the list of verified identities. You can execute this operation no more than once per second.

    Args:
        identity(str): The identity to be removed from the list of identities for the AWS Account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.init.delete(ctx, identity=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.init.delete identity=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_identity",
        op_kwargs={"Identity": identity},
    )


async def list_all(
    hub, ctx, identity_type: str = None, next_token: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list containing all of the identities (email addresses and domains) for your AWS account in the current AWS Region, regardless of verification status. You can execute this operation no more than once per second.

    Args:
        identity_type(str, optional): The type of the identities to list. Possible values are "EmailAddress" and "Domain". If this parameter is omitted, then all identities will be listed. Defaults to None.
        next_token(str, optional): The token to use for pagination. Defaults to None.
        max_items(int, optional): The maximum number of identities per page. Possible values are 1-1000 inclusive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="list_identities",
        op_kwargs={
            "IdentityType": identity_type,
            "NextToken": next_token,
            "MaxItems": max_items,
        },
    )
