"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, identity: str, notification_type: str, enabled: bool) -> Dict:
    r"""
    **Autogenerated function**

    Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type. You can execute this operation no more than once per second. For more information about using notifications with Amazon SES, see the Amazon SES Developer Guide.

    Args:
        identity(str): The identity for which to enable or disable headers in notifications. Examples: user@example.com, example.com.
        notification_type(str): The notification type for which to enable or disable headers in notifications. .
        enabled(bool): Sets whether Amazon SES includes the original email headers in Amazon SNS notifications of the specified notification type. A value of true specifies that Amazon SES will include headers in notifications, and a value of false specifies that Amazon SES will not include headers in notifications. This value can only be set when NotificationType is already set to use a particular Amazon SNS topic.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.header_in_notification_enabled.set(
                ctx, identity=value, notification_type=value, enabled=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.header_in_notification_enabled.set identity=value, notification_type=value, enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="set_identity_headers_in_notifications_enabled",
        op_kwargs={
            "Identity": identity,
            "NotificationType": notification_type,
            "Enabled": enabled,
        },
    )
