"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, identity: str, dkim_enabled: bool) -> Dict:
    r"""
    **Autogenerated function**

    Enables or disables Easy DKIM signing of email sent from an identity. If Easy DKIM signing is enabled for a domain, then Amazon SES uses DKIM to sign all email that it sends from addresses on that domain. If Easy DKIM signing is enabled for an email address, then Amazon SES uses DKIM to sign all email it sends from that address.  For email addresses (for example, user@example.com), you can only enable DKIM signing if the corresponding domain (in this case, example.com) has been set up to use Easy DKIM.  You can enable DKIM signing for an identity at any time after you start the verification process for the identity, even if the verification process isn't complete.  You can execute this operation no more than once per second. For more information about Easy DKIM signing, go to the Amazon SES Developer Guide.

    Args:
        identity(str): The identity for which DKIM signing should be enabled or disabled.
        dkim_enabled(bool): Sets whether DKIM signing is enabled for an identity. Set to true to enable DKIM signing for this identity; false to disable it. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.dkim.enabled.set(
                ctx, identity=value, dkim_enabled=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.dkim.enabled.set identity=value, dkim_enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="set_identity_dkim_enabled",
        op_kwargs={"Identity": identity, "DkimEnabled": dkim_enabled},
    )
