"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, identities: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current status of Easy DKIM signing for an entity. For domain name identities, this operation also returns the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES has successfully verified that these tokens have been published. This operation takes a list of identities as input and returns the following information for each:   Whether Easy DKIM signing is enabled or disabled.   A set of DKIM tokens that represent the identity. If the identity is an email address, the tokens represent the domain of that address.   Whether Amazon SES has successfully verified the DKIM tokens published in the domain's DNS. This information is only returned for domain name identities, not for email addresses.   This operation is throttled at one request per second and can only get DKIM attributes for up to 100 identities at a time. For more information about creating DNS records using DKIM tokens, go to the Amazon SES Developer Guide.

    Args:
        identities(List): A list of one or more verified identities - email addresses, domains, or both.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.identity.dkim.attribute.get_all(ctx, identities=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.identity.dkim.attribute.get_all identities=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="get_identity_dkim_attributes",
        op_kwargs={"Identities": identities},
    )
