"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def verify(hub, ctx, email_address: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds an email address to the list of identities for your Amazon SES account in the current AWS region and attempts to verify it. As a result of executing this operation, a verification email is sent to the specified address. You can execute this operation no more than once per second.

    Args:
        email_address(str): The email address to be verified.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.email.identity.verify(ctx, email_address=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.email.identity.verify email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="verify_email_identity",
        op_kwargs={"EmailAddress": email_address},
    )
