"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def verify(hub, ctx, domain: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a domain to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. For more information about verifying domains, see Verifying Email Addresses and Domains in the Amazon SES Developer Guide.  You can execute this operation no more than once per second.

    Args:
        domain(str): The domain to be verified.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.domain.identity.verify(ctx, domain=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.domain.identity.verify domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="verify_domain_identity",
        op_kwargs={"Domain": domain},
    )
