"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    template_name: str,
    from_email_address: str,
    template_subject: str,
    template_content: str,
    success_redirection_url: str,
    failure_redirection_url: str,
) -> None:
    r"""
    **Autogenerated function**

    Creates a new custom verification email template. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template.
        from_email_address(str): The email address that the custom verification email is sent from.
        template_subject(str): The subject line of the custom verification email.
        template_content(str): The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see Custom Verification Email Frequently Asked Questions in the Amazon SES Developer Guide.
        success_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
        failure_redirection_url(str): The URL that the recipient of the verification email is sent to if his or her address is not successfully verified.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.template.create(
                ctx,
                template_name=value,
                from_email_address=value,
                template_subject=value,
                template_content=value,
                success_redirection_url=value,
                failure_redirection_url=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.template.create template_name=value, from_email_address=value, template_subject=value, template_content=value, success_redirection_url=value, failure_redirection_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_custom_verification_email_template",
        op_kwargs={
            "TemplateName": template_name,
            "FromEmailAddress": from_email_address,
            "TemplateSubject": template_subject,
            "TemplateContent": template_content,
            "SuccessRedirectionURL": success_redirection_url,
            "FailureRedirectionURL": failure_redirection_url,
        },
    )


async def delete(hub, ctx, template_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing custom verification email template.  For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.template.delete(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.template.delete template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_custom_verification_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def get(hub, ctx, template_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the custom email verification template for the template name you specify. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.template.get(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.template.get template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="get_custom_verification_email_template",
        op_kwargs={"TemplateName": template_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the existing custom verification email templates for your account in the current AWS Region. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        next_token(str, optional): An array the contains the name and creation time stamp for each template in your Amazon SES account. Defaults to None.
        max_results(int, optional): The maximum number of custom verification email templates to return. This value must be at least 1 and less than or equal to 50. If you do not specify a value, or if you specify a value less than 1 or greater than 50, the operation will return up to 50 results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="list_custom_verification_email_templates",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def update(
    hub,
    ctx,
    template_name: str,
    from_email_address: str = None,
    template_subject: str = None,
    template_content: str = None,
    success_redirection_url: str = None,
    failure_redirection_url: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates an existing custom verification email template. For more information about custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        template_name(str): The name of the custom verification email template that you want to update.
        from_email_address(str, optional): The email address that the custom verification email is sent from. Defaults to None.
        template_subject(str, optional): The subject line of the custom verification email. Defaults to None.
        template_content(str, optional): The content of the custom verification email. The total size of the email must be less than 10 MB. The message body may contain HTML, with some limitations. For more information, see Custom Verification Email Frequently Asked Questions in the Amazon SES Developer Guide. Defaults to None.
        success_redirection_url(str, optional): The URL that the recipient of the verification email is sent to if his or her address is successfully verified. Defaults to None.
        failure_redirection_url(str, optional): The URL that the recipient of the verification email is sent to if his or her address is not successfully verified. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.template.update(
                ctx, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.template.update template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_custom_verification_email_template",
        op_kwargs={
            "TemplateName": template_name,
            "FromEmailAddress": from_email_address,
            "TemplateSubject": template_subject,
            "TemplateContent": template_content,
            "SuccessRedirectionURL": success_redirection_url,
            "FailureRedirectionURL": failure_redirection_url,
        },
    )
