"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def send(
    hub, ctx, email_address: str, template_name: str, configuration_set_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it. As a result of executing this operation, a customized verification email is sent to the specified address. To use this operation, you must first create a custom verification email template. For more information about creating and using custom verification email templates, see Using Custom Verification Email Templates in the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        email_address(str): The email address to verify.
        template_name(str): The name of the custom verification email template to use when sending the verification email.
        configuration_set_name(str, optional): Name of a configuration set to use when sending the verification email. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.custom_verification_email.init.send(
                ctx, email_address=value, template_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.custom_verification_email.init.send email_address=value, template_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="send_custom_verification_email",
        op_kwargs={
            "EmailAddress": email_address,
            "TemplateName": template_name,
            "ConfigurationSetName": configuration_set_name,
        },
    )
