"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create_multiple(
    hub, ctx, configuration_set_name: str, tracking_options: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between a configuration set and a custom domain for open and click event tracking.  By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the Amazon SES Developer Guide.

    Args:
        configuration_set_name(str): The name of the configuration set that the tracking options should be associated with.
        tracking_options(Dict): A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails. For more information, see Configuring Custom Domains to Handle Open and Click Tracking in the Amazon SES Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.tracking_option.create_multiple(
                ctx, configuration_set_name=value, tracking_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.tracking_option.create_multiple configuration_set_name=value, tracking_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_configuration_set_tracking_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "TrackingOptions": tracking_options,
        },
    )


async def delete_multiple(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an association between a configuration set and a custom domain for open and click event tracking. By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the Amazon SES Developer Guide.  Deleting this kind of association will result in emails sent using the specified configuration set to capture open and click events using the standard, Amazon SES-operated domains.

    Args:
        configuration_set_name(str): The name of the configuration set from which you want to delete the tracking options.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.tracking_option.delete_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.tracking_option.delete_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_configuration_set_tracking_options",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def update_multiple(
    hub, ctx, configuration_set_name: str, tracking_options: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an association between a configuration set and a custom domain for open and click event tracking.  By default, images and links used for tracking open and click events are hosted on domains operated by Amazon SES. You can configure a subdomain of your own to handle these events. For information about using custom domains, see the Amazon SES Developer Guide.

    Args:
        configuration_set_name(str): The name of the configuration set for which you want to update the custom tracking domain.
        tracking_options(Dict): A domain that is used to redirect email recipients to an Amazon SES-operated domain. This domain captures open and click events generated by Amazon SES emails. For more information, see Configuring Custom Domains to Handle Open and Click Tracking in the Amazon SES Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.tracking_option.update_multiple(
                ctx, configuration_set_name=value, tracking_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.tracking_option.update_multiple configuration_set_name=value, tracking_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_configuration_set_tracking_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "TrackingOptions": tracking_options,
        },
    )
