"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, configuration_set_name: str, enabled: bool) -> None:
    r"""
    **Autogenerated function**

    Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending for a configuration set when the reputation metrics for that configuration set (such as your bounce on complaint rate) exceed certain thresholds. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to update.
        enabled(bool): Describes whether email sending is enabled or disabled for the configuration set. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.sending_enabled.update(
                ctx, configuration_set_name=value, enabled=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.sending_enabled.update configuration_set_name=value, enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_configuration_set_sending_enabled",
        op_kwargs={"ConfigurationSetName": configuration_set_name, "Enabled": enabled},
    )
