"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, configuration_set_name: str, enabled: bool) -> None:
    r"""
    **Autogenerated function**

    Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given AWS Region. Reputation metrics include bounce and complaint rates. These metrics are published to Amazon CloudWatch. By using CloudWatch, you can create alarms when bounce or complaint rates exceed certain thresholds. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to update.
        enabled(bool): Describes whether or not Amazon SES will publish reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.reputation_metric_enabled.update(
                ctx, configuration_set_name=value, enabled=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.reputation_metric_enabled.update configuration_set_name=value, enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_configuration_set_reputation_metrics_enabled",
        op_kwargs={"ConfigurationSetName": configuration_set_name, "Enabled": enabled},
    )
