"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, configuration_set: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        configuration_set(Dict): A data structure that contains the name of the configuration set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.init.create(ctx, configuration_set=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.init.create configuration_set=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_configuration_set",
        op_kwargs={"ConfigurationSet": configuration_set},
    )


async def delete(hub, ctx, configuration_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a configuration set. Configuration sets enable you to publish email sending events. For information about using configuration sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.init.delete(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.init.delete configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_configuration_set",
        op_kwargs={"ConfigurationSetName": configuration_set_name},
    )


async def describe(
    hub,
    ctx,
    configuration_set_name: str,
    configuration_set_attribute_names: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of the specified configuration set. For information about using configuration sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set to describe.
        configuration_set_attribute_names(List, optional): A list of configuration set attributes to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.init.describe(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.init.describe configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="describe_configuration_set",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "ConfigurationSetAttributeNames": configuration_set_attribute_names,
        },
    )


async def list_all(hub, ctx, next_token: str = None, max_items: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of the configuration sets associated with your Amazon SES account in the current AWS Region. For information about using configuration sets, see Monitoring Your Amazon SES Sending Activity in the Amazon SES Developer Guide.  You can execute this operation no more than once per second. This operation will return up to 1,000 configuration sets each time it is run. If your Amazon SES account has more than 1,000 configuration sets, this operation will also return a NextToken element. You can then execute the ListConfigurationSets operation again, passing the NextToken parameter and the value of the NextToken element to retrieve additional results.

    Args:
        next_token(str, optional): A token returned from a previous call to ListConfigurationSets to indicate the position of the configuration set in the configuration set list. Defaults to None.
        max_items(int, optional): The number of configuration sets to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="list_configuration_sets",
        op_kwargs={"NextToken": next_token, "MaxItems": max_items},
    )
