"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, configuration_set_name: str, event_destination: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a configuration set event destination.  When you create or update an event destination, you must provide one, and only one, destination. The destination can be CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).  An event destination is the AWS service to which Amazon SES publishes the email sending events associated with a configuration set. For information about using configuration sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set that the event destination should be associated with.
        event_destination(Dict): An object that describes the AWS service that email sending event information will be published to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.event_destination.create(
                ctx, configuration_set_name=value, event_destination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.event_destination.create configuration_set_name=value, event_destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="create_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestination": event_destination,
        },
    )


async def delete(
    hub, ctx, configuration_set_name: str, event_destination_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a configuration set event destination. Configuration set event destinations are associated with configuration sets, which enable you to publish email sending events. For information about using configuration sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set from which to delete the event destination.
        event_destination_name(str): The name of the event destination to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.event_destination.delete(
                ctx, configuration_set_name=value, event_destination_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.event_destination.delete configuration_set_name=value, event_destination_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="delete_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestinationName": event_destination_name,
        },
    )


async def update(
    hub, ctx, configuration_set_name: str, event_destination: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the event destination of a configuration set. Event destinations are associated with configuration sets, which enable you to publish email sending events to Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS). For information about using configuration sets, see Monitoring Your Amazon SES Sending Activity in the Amazon SES Developer Guide.   When you create or update an event destination, you must provide one, and only one, destination. The destination can be Amazon CloudWatch, Amazon Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).  You can execute this operation no more than once per second.

    Args:
        configuration_set_name(str): The name of the configuration set that contains the event destination that you want to update.
        event_destination(Dict): The event destination object that you want to apply to the specified configuration set.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.event_destination.update(
                ctx, configuration_set_name=value, event_destination=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.event_destination.update configuration_set_name=value, event_destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_configuration_set_event_destination",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "EventDestination": event_destination,
        },
    )
