"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put_multiple(
    hub, ctx, configuration_set_name: str, delivery_options: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates the delivery options for a configuration set.

    Args:
        configuration_set_name(str): The name of the configuration set that you want to specify the delivery options for.
        delivery_options(Dict, optional): Specifies whether messages that use the configuration set are required to use Transport Layer Security (TLS). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.configuration_set_.delivery_option.put_multiple(
                ctx, configuration_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.configuration_set_.delivery_option.put_multiple configuration_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="put_configuration_set_delivery_options",
        op_kwargs={
            "ConfigurationSetName": configuration_set_name,
            "DeliveryOptions": delivery_options,
        },
    )
