"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def send(
    hub,
    ctx,
    original_message_id: str,
    bounce_sender: str,
    bounced_recipient_info_list: List,
    explanation: str = None,
    message_dsn: Dict = None,
    bounce_sender_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Generates and sends a bounce message to the sender of an email you received through Amazon SES. You can only use this API on an email up to 24 hours after you receive it.  You cannot use this API to send generic bounces for mail that was not received by Amazon SES.  For information about receiving email through Amazon SES, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        original_message_id(str): The message ID of the message to be bounced.
        bounce_sender(str): The address to use in the "From" header of the bounce message. This must be an identity that you have verified with Amazon SES.
        explanation(str, optional): Human-readable text for the bounce message to explain the failure. If not specified, the text will be auto-generated based on the bounced recipient information. Defaults to None.
        message_dsn(Dict, optional): Message-related DSN fields. If not specified, Amazon SES will choose the values. Defaults to None.
        bounced_recipient_info_list(List): A list of recipients of the bounced message, including the information required to create the Delivery Status Notifications (DSNs) for the recipients. You must specify at least one BouncedRecipientInfo in the list.
        bounce_sender_arn(str, optional): This parameter is used only for sending authorization. It is the ARN of the identity that is associated with the sending authorization policy that permits you to use the address in the "From" header of the bounce. For more information about sending authorization, see the Amazon SES Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.bounce.send(
                ctx,
                original_message_id=value,
                bounce_sender=value,
                bounced_recipient_info_list=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.bounce.send original_message_id=value, bounce_sender=value, bounced_recipient_info_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="send_bounce",
        op_kwargs={
            "OriginalMessageId": original_message_id,
            "BounceSender": bounce_sender,
            "Explanation": explanation,
            "MessageDsn": message_dsn,
            "BouncedRecipientInfoList": bounced_recipient_info_list,
            "BounceSenderArn": bounce_sender_arn,
        },
    )
