"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "active_receipt_rule_set"


__func_alias__ = {"set_": "set"}


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the metadata and receipt rules for the receipt rule set that is currently active. For information about setting up receipt rule sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.active_receipt_rule_set_.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.active_receipt_rule_set.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="describe_active_receipt_rule_set",
        op_kwargs={},
    )


async def set_(hub, ctx, rule_set_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Sets the specified receipt rule set as the active receipt rule set.  To disable your email-receiving through Amazon SES completely, you can call this API with RuleSetName set to null.  For information about managing receipt rule sets, see the Amazon SES Developer Guide. You can execute this operation no more than once per second.

    Args:
        rule_set_name(str, optional): The name of the receipt rule set to make active. Setting this value to null disables all email receiving. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.active_receipt_rule_set_.set(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.active_receipt_rule_set.set
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="set_active_receipt_rule_set",
        op_kwargs={"RuleSetName": rule_set_name},
    )
