"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the email sending status of the Amazon SES account for the current region. You can execute this operation no more than once per second.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.account_sending_enabled.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.account_sending_enabled.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="ses", operation="get_account_sending_enabled", op_kwargs={}
    )


async def update(hub, ctx, enabled: bool = None) -> None:
    r"""
    **Autogenerated function**

    Enables or disables email sending across your entire Amazon SES account in the current AWS Region. You can use this operation in conjunction with Amazon CloudWatch alarms to temporarily pause email sending across your Amazon SES account in a given AWS Region when reputation metrics (such as your bounce or complaint rates) reach certain thresholds. You can execute this operation no more than once per second.

    Args:
        enabled(bool, optional): Describes whether email sending is enabled or disabled for your Amazon SES account in the current AWS Region. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ses.account_sending_enabled.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ses.account_sending_enabled.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ses",
        operation="update_account_sending_enabled",
        op_kwargs={"Enabled": enabled},
    )
