"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    vpc: str,
    creator_request_id: str = None,
    description: str = None,
    tags: List = None,
    properties: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace example.com and name your service backend, the resulting DNS name for the service is backend.example.com. Service instances that are registered using a private DNS namespace can be discovered using either a DiscoverInstances request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see Cloud Map quotas in the Cloud Map Developer Guide.

    Args:
        name(str): The name that you want to assign to this namespace. When you create a private DNS namespace, Cloud Map automatically creates an Amazon Route 53 private hosted zone that has the same name as the namespace.
        creator_request_id(str, optional): A unique string that identifies the request and that allows failed CreatePrivateDnsNamespace requests to be retried without the risk of running the operation twice. CreatorRequestId can be any unique string (for example, a date/timestamp). Defaults to None.
        description(str, optional): A description for the namespace. Defaults to None.
        vpc(str): The ID of the Amazon VPC that you want to associate the namespace with.
        tags(List, optional): The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length. Defaults to None.
        properties(Dict, optional): Properties for the private DNS namespace. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.private_dns_namespace.create(
                ctx, name=value, vpc=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.private_dns_namespace.create name=value, vpc=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="create_private_dns_namespace",
        op_kwargs={
            "Name": name,
            "CreatorRequestId": creator_request_id,
            "Description": description,
            "Vpc": vpc,
            "Tags": tags,
            "Properties": properties,
        },
    )


async def update(
    hub, ctx, id_: str, namespace: Dict, updater_request_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a private DNS namespace.

    Args:
        id_(str): The ID of the namespace that you want to update.
        updater_request_id(str, optional): A unique string that identifies the request and that allows failed UpdatePrivateDnsNamespace requests to be retried without the risk of running the operation twice. UpdaterRequestId can be any unique string (for example, a date/timestamp). Defaults to None.
        namespace(Dict): Updated properties for the private DNS namespace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.private_dns_namespace.update(
                ctx, id_=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.private_dns_namespace.update id_=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="update_private_dns_namespace",
        op_kwargs={
            "Id": id_,
            "UpdaterRequestId": updater_request_id,
            "Namespace": namespace,
        },
    )
