"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, operation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about any operation that returns an operation ID in the response, such as a CreateService request.  To get a list of operations that match specified criteria, see ListOperations.

    Args:
        operation_id(str): The ID of the operation that you want to get more information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.operation.get(ctx, operation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.operation.get operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="get_operation",
        op_kwargs={"OperationId": operation_id},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists operations that match the criteria that you specify.

    Args:
        next_token(str, optional): For the first ListOperations request, omit this value. If the response contains NextToken, submit another ListOperations request to get the next group of results. Specify the value of NextToken from the previous response in the next request.  Cloud Map gets MaxResults operations and then filters them based on the specified criteria. It's possible that no operations in the first MaxResults operations matched the specified criteria but that subsequent groups of MaxResults operations do contain operations that match the criteria. . Defaults to None.
        max_results(int, optional): The maximum number of items that you want Cloud Map to return in the response to a ListOperations request. If you don't specify a value for MaxResults, Cloud Map returns up to 100 operations. Defaults to None.
        filters(List, optional): A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date. If you specify more than one filter, an operation must match all filters to be returned by ListOperations. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.operation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.operation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="list_operations",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
