"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.

    Args:
        id_(str): The ID of the namespace that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.namespace.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.namespace.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="delete_namespace",
        op_kwargs={"Id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a namespace.

    Args:
        id_(str): The ID of the namespace that you want to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.namespace.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.namespace.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="get_namespace",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub, ctx, next_token: str = None, max_results: int = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists summary information about the namespaces that were created by the current account.

    Args:
        next_token(str, optional): For the first ListNamespaces request, omit this value. If the response contains NextToken, submit another ListNamespaces request to get the next group of results. Specify the value of NextToken from the previous response in the next request.  Cloud Map gets MaxResults namespaces and then filters them based on the specified criteria. It's possible that no namespaces in the first MaxResults namespaces matched the specified criteria but that subsequent groups of MaxResults namespaces do contain namespaces that match the criteria. . Defaults to None.
        max_results(int, optional): The maximum number of namespaces that you want Cloud Map to return in the response to a ListNamespaces request. If you don't specify a value for MaxResults, Cloud Map returns up to 100 namespaces. Defaults to None.
        filters(List, optional): A complex type that contains specifications for the namespaces that you want to list. If you specify more than one filter, a namespace must match all filters to be returned by ListNamespaces. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.namespace.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.namespace.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="list_namespaces",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
        },
    )
