"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(hub, ctx, service_id: str, instance_id: str, status: str) -> None:
    r"""
    **Autogenerated function**

    Submits a request to change the health status of a custom health check to healthy or unhealthy. You can use UpdateInstanceCustomHealthStatus to change the status only for custom health checks, which you define using HealthCheckCustomConfig when you create a service. You can't use it to change the status for Route 53 health checks, which you define using HealthCheckConfig. For more information, see HealthCheckCustomConfig.

    Args:
        service_id(str): The ID of the service that includes the configuration for the custom health check that you want to change the status for.
        instance_id(str): The ID of the instance that you want to change the health status for.
        status(str): The new status of the instance, HEALTHY or UNHEALTHY.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.instance.custom_health_status.update(
                ctx, service_id=value, instance_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.instance.custom_health_status.update service_id=value, instance_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="update_instance_custom_health_status",
        op_kwargs={
            "ServiceId": service_id,
            "InstanceId": instance_id,
            "Status": status,
        },
    )
