"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    creator_request_id: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a DiscoverInstances request but can't be discovered using DNS. For the current quota on the number of namespaces that you can create using the same account, see Cloud Map quotas in the Cloud Map Developer Guide.

    Args:
        name(str): The name that you want to assign to this namespace.
        creator_request_id(str, optional): A unique string that identifies the request and that allows failed CreateHttpNamespace requests to be retried without the risk of running the operation twice. CreatorRequestId can be any unique string (for example, a date/time stamp). Defaults to None.
        description(str, optional): A description for the namespace. Defaults to None.
        tags(List, optional): The tags to add to the namespace. Each tag consists of a key and an optional value that you define. Tags keys can be up to 128 characters in length, and tag values can be up to 256 characters in length. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.http_namespace.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.http_namespace.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="create_http_namespace",
        op_kwargs={
            "Name": name,
            "CreatorRequestId": creator_request_id,
            "Description": description,
            "Tags": tags,
        },
    )


async def update(
    hub, ctx, id_: str, namespace: Dict, updater_request_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an HTTP namespace.

    Args:
        id_(str): The ID of the namespace that you want to update.
        updater_request_id(str, optional): A unique string that identifies the request and that allows failed UpdateHttpNamespace requests to be retried without the risk of running the operation twice. UpdaterRequestId can be any unique string (for example, a date/timestamp). Defaults to None.
        namespace(Dict): Updated properties for the the HTTP namespace.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicediscovery.http_namespace.update(
                ctx, id_=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicediscovery.http_namespace.update id_=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicediscovery",
        operation="update_http_namespace",
        op_kwargs={
            "Id": id_,
            "UpdaterRequestId": updater_request_id,
            "Namespace": namespace,
        },
    )
