"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, application: str, resource_type: str, resource: str
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a resource with an application. Both the resource and the application can be specified either by ID or name.

    Args:
        application(str): The name or ID of the application.
        resource_type(str): The type of resource of which the application will be associated.
        resource(str): The name or ID of the resource of which the application will be associated.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.resource.associate(
                ctx, application=value, resource_type=value, resource=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.resource.associate application=value, resource_type=value, resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="associate_resource",
        op_kwargs={
            "application": application,
            "resourceType": resource_type,
            "resource": resource,
        },
    )


async def disassociate(
    hub, ctx, application: str, resource_type: str, resource: str
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.

    Args:
        application(str): The name or ID of the application.
        resource_type(str): The type of the resource that is being disassociated.
        resource(str): The name or ID of the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.resource.disassociate(
                ctx, application=value, resource_type=value, resource=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.resource.disassociate application=value, resource_type=value, resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="disassociate_resource",
        op_kwargs={
            "application": application,
            "resourceType": resource_type,
            "resource": resource,
        },
    )


async def sync(hub, ctx, resource_type: str, resource: str) -> Dict:
    r"""
    **Autogenerated function**

    Syncs the resource with what is currently recorded in App registry. Specifically, the resource’s App registry system tags are synced with its associated application. The resource is removed if it is not associated with the application. The caller must have permissions to read and update the resource.

    Args:
        resource_type(str): The type of resource of which the application will be associated.
        resource(str): An entity you can work with and specify with a name or ID. Examples include an Amazon EC2 instance, an AWS CloudFormation stack, or an Amazon S3 bucket.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.resource.sync(
                ctx, resource_type=value, resource=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.resource.sync resource_type=value, resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="sync_resource",
        op_kwargs={"resourceType": resource_type, "resource": resource},
    )


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Assigns one or more tags (key-value pairs) to the specified resource. Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value. This operation returns an empty response if the call was successful.

    Args:
        resource_arn(str): The Amazon resource name (ARN) that specifies the resource.
        tags(Dict): The new or modified tags for the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.resource.tag(
                ctx, resource_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="tag_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from a resource. This operation returns an empty response if the call was successful.

    Args:
        resource_arn(str): The Amazon resource name (ARN) that specifies the resource.
        tag_keys(List): A list of the tag keys to remove from the specified resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="untag_resource",
        op_kwargs={"resourceArn": resource_arn, "tagKeys": tag_keys},
    )
