"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, application: str, attribute_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates an attribute group with an application to augment the application's metadata with the group's attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.

    Args:
        application(str): The name or ID of the application.
        attribute_group(str): The name or ID of the attribute group that holds the attributes to describe the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.associate(
                ctx, application=value, attribute_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.associate application=value, attribute_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="associate_attribute_group",
        op_kwargs={"application": application, "attributeGroup": attribute_group},
    )


async def create(
    hub,
    ctx,
    name: str,
    attributes: str,
    client_token: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.

    Args:
        name(str): The name of the attribute group.
        description(str, optional): The description of the attribute group that the user provides. Defaults to None.
        attributes(str): A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components.
        tags(Dict, optional): Key-value pairs you can use to associate with the attribute group. Defaults to None.
        client_token(str): A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.create(
                ctx, name=value, attributes=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.create name=value, attributes=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="create_attribute_group",
        op_kwargs={
            "name": name,
            "description": description,
            "attributes": attributes,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, attribute_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an attribute group, specified either by its attribute group ID or name.

    Args:
        attribute_group(str): The name or ID of the attribute group that holds the attributes to describe the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.delete(
                ctx, attribute_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.delete attribute_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="delete_attribute_group",
        op_kwargs={"attributeGroup": attribute_group},
    )


async def disassociate(hub, ctx, application: str, attribute_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata. This operation reverts AssociateAttributeGroup.

    Args:
        application(str): The name or ID of the application.
        attribute_group(str): The name or ID of the attribute group that holds the attributes to describe the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.disassociate(
                ctx, application=value, attribute_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.disassociate application=value, attribute_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="disassociate_attribute_group",
        op_kwargs={"application": application, "attributeGroup": attribute_group},
    )


async def get(hub, ctx, attribute_group: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves an attribute group, either by its name or its ID. The attribute group can be specified either by its unique ID or by its name.

    Args:
        attribute_group(str): The name or ID of the attribute group that holds the attributes to describe the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.get(
                ctx, attribute_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.get attribute_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="get_attribute_group",
        op_kwargs={"attributeGroup": attribute_group},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all attribute groups which you have access to. Results are paginated.

    Args:
        next_token(str, optional): The token to use to get the next page of results after a previous API call. . Defaults to None.
        max_results(int, optional): The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="list_attribute_groups",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    attribute_group: str,
    name: str = None,
    description: str = None,
    attributes: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing attribute group with new details.

    Args:
        attribute_group(str): The name or ID of the attribute group that holds the attributes to describe the application.
        name(str, optional): The new name of the attribute group. The name must be unique in the region in which you are updating the attribute group. Defaults to None.
        description(str, optional): The description of the attribute group that the user provides. Defaults to None.
        attributes(str, optional): A JSON string in the form of nested key-value pairs that represent the attributes in the group and describes an application and its components. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.attribute_group.update(
                ctx, attribute_group=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.attribute_group.update attribute_group=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="update_attribute_group",
        op_kwargs={
            "attributeGroup": attribute_group,
            "name": name,
            "description": description,
            "attributes": attributes,
        },
    )
