"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, application: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all resources that are associated with specified application. Results are paginated.

    Args:
        application(str): The name or ID of the application.
        next_token(str, optional): The token to use to get the next page of results after a previous API call. . Defaults to None.
        max_results(int, optional): The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.associated.resource.list_all(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.associated.resource.list_all application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="list_associated_resources",
        op_kwargs={
            "application": application,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
