"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, client_token: str, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.

    Args:
        name(str): The name of the application. The name must be unique in the region in which you are creating the application.
        description(str, optional): The description of the application. Defaults to None.
        tags(Dict, optional): Key-value pairs you can use to associate with the application. Defaults to None.
        client_token(str): A unique identifier that you provide to ensure idempotency. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.application.create(
                ctx, name=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.application.create name=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="create_application",
        op_kwargs={
            "name": name,
            "description": description,
            "tags": tags,
            "clientToken": client_token,
        },
    )


async def delete(hub, ctx, application: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an application that is specified either by its application ID or name. All associated attribute groups and resources must be disassociated from it before deleting an application.

    Args:
        application(str): The name or ID of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.application.delete(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.application.delete application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="delete_application",
        op_kwargs={"application": application},
    )


async def get(hub, ctx, application: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves metadata information about one of your applications. The application can be specified either by its unique ID or by its name (which is unique within one account in one region at a given point in time). Specify by ID in automated workflows if you want to make sure that the exact same application is returned or a ResourceNotFoundException is thrown, avoiding the ABA addressing problem.

    Args:
        application(str): The name or ID of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.application.get(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.application.get application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="get_application",
        op_kwargs={"application": application},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of all of your applications. Results are paginated.

    Args:
        next_token(str, optional): The token to use to get the next page of results after a previous API call. . Defaults to None.
        max_results(int, optional): The upper bound of the number of results to return (cannot exceed 25). If this parameter is omitted, it defaults to 25. This value is optional. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.application.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.application.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="list_applications",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub, ctx, application: str, name: str = None, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing application with new attributes.

    Args:
        application(str): The name or ID of the application that will be updated.
        name(str, optional): The new name of the application. The name must be unique in the region in which you are updating the application. Defaults to None.
        description(str, optional): The new description of the application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog_appregistry.application.update(
                ctx, application=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog_appregistry.application.update application=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog-appregistry",
        operation="update_application",
        op_kwargs={
            "application": application,
            "name": name,
            "description": description,
        },
    )
