"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, key: str, value: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a TagOption.

    Args:
        key(str): The TagOption key.
        value(str): The TagOption value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.init.create(
                ctx, key=value, value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.init.create key=value, value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_tag_option",
        op_kwargs={"Key": key, "Value": value},
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified TagOption. You cannot delete a TagOption if it is associated with a product or portfolio.

    Args:
        id_(str): The TagOption identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_tag_option",
        op_kwargs={"Id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified TagOption.

    Args:
        id_(str): The TagOption identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_tag_option",
        op_kwargs={"Id": id_},
    )


async def list_all(
    hub, ctx, filters: Dict = None, page_size: int = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified TagOptions or all TagOptions.

    Args:
        filters(Dict, optional): The search filters. If no search filters are specified, the output includes all TagOptions. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_tag_options",
        op_kwargs={"Filters": filters, "PageSize": page_size, "PageToken": page_token},
    )


async def update(hub, ctx, id_: str, value: str = None, active: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified TagOption.

    Args:
        id_(str): The TagOption identifier.
        value(str, optional): The updated value. Defaults to None.
        active(bool, optional): The updated active state. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_tag_option",
        op_kwargs={"Id": id_, "Value": value, "Active": active},
    )
