"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, resource_id: str, tag_option_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified TagOption from the specified resource.

    Args:
        resource_id(str): The resource identifier.
        tag_option_id(str): The TagOption identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.tag_option.from_resource.disassociate(
                ctx, resource_id=value, tag_option_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.tag_option.from_resource.disassociate resource_id=value, tag_option_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disassociate_tag_option_from_resource",
        op_kwargs={"ResourceId": resource_id, "TagOptionId": tag_option_id},
    )
