"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    provisioned_product_id: str,
    accept_language: str = None,
    page_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about stack instances that are associated with the specified CFN_STACKSET type provisioned product. You can filter for stack instances that are associated with a specific AWS account name or region.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provisioned_product_id(str): The identifier of the provisioned product.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.stack_instance_for_provisioned_product.list(
                ctx, provisioned_product_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.stack_instance_for_provisioned_product.list provisioned_product_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_stack_instances_for_provisioned_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisionedProductId": provisioned_product_id,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )
