"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    definition_type: str,
    definition: Dict,
    idempotency_token: str,
    description: str = None,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a self-service action.

    Args:
        name(str): The self-service action name.
        definition_type(str): The service action definition type. For example, SSM_AUTOMATION.
        definition(Dict): The self-service action definition. Can be one of the following:  Name  The name of the AWS Systems Manager document (SSM document). For example, AWS-RestartEC2Instance. If you are using a shared SSM document, you must provide the ARN instead of the name.  Version  The AWS Systems Manager automation document version. For example, "Version": "1"   AssumeRole  The Amazon Resource Name (ARN) of the role that performs the self-service actions on your behalf. For example, "AssumeRole": "arn:aws:iam::12345678910:role/ActionRole". To reuse the provisioned product launch role, set to "AssumeRole": "LAUNCH_ROLE".  Parameters  The list of parameters in JSON format. For example: [{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}] or [{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}].  .
        description(str, optional): The self-service action description. Defaults to None.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.init.create(
                ctx, name=value, definition_type=value, definition=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.init.create name=value, definition_type=value, definition=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_service_action",
        op_kwargs={
            "Name": name,
            "DefinitionType": definition_type,
            "Definition": definition,
            "Description": description,
            "AcceptLanguage": accept_language,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, id_: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a self-service action.

    Args:
        id_(str): The self-service action identifier. For example, act-fs7abcd89wxyz.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_service_action",
        op_kwargs={"Id": id_, "AcceptLanguage": accept_language},
    )


async def describe(hub, ctx, id_: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes a self-service action.

    Args:
        id_(str): The self-service action identifier.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_service_action",
        op_kwargs={"Id": id_, "AcceptLanguage": accept_language},
    )


async def list_all(
    hub, ctx, accept_language: str = None, page_size: int = None, page_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all self-service actions.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_service_actions",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )


async def update(
    hub,
    ctx,
    id_: str,
    name: str = None,
    definition: Dict = None,
    description: str = None,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a self-service action.

    Args:
        id_(str): The self-service action identifier.
        name(str, optional): The self-service action name. Defaults to None.
        definition(Dict, optional): A map that defines the self-service action. Defaults to None.
        description(str, optional): The self-service action description. Defaults to None.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_service_action",
        op_kwargs={
            "Id": id_,
            "Name": name,
            "Definition": definition,
            "Description": description,
            "AcceptLanguage": accept_language,
        },
    )
