"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub,
    ctx,
    product_id: str,
    provisioning_artifact_id: str,
    service_action_id: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified self-service action association from the specified provisioning artifact.

    Args:
        product_id(str): The product identifier. For example, prod-abcdzk7xy33qa.
        provisioning_artifact_id(str): The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
        service_action_id(str): The self-service action identifier. For example, act-fs7abcd89wxyz.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.from_provisioning_artifact.disassociate(
                ctx, product_id=value, provisioning_artifact_id=value, service_action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.from_provisioning_artifact.disassociate product_id=value, provisioning_artifact_id=value, service_action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disassociate_service_action_from_provisioning_artifact",
        op_kwargs={
            "ProductId": product_id,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ServiceActionId": service_action_id,
            "AcceptLanguage": accept_language,
        },
    )
